#!/bin/sh

# Installing python packages...
echo "Installing dependencies..."
pip install wheel cython
pip install -r scripts/cpanel_requirements.txt --only-binary pillow,aiohttp,multidict,yarl,cryptography,cffi


# Applying migrations
python3 manage.py migrate --skip-checks

echo "Applying seeds..."
python3 manage.py loaddata app/seeds/settings.json
python3 manage.py loaddata app/seeds/pages.json
python3 manage.py loaddata app/seeds/admin_interface.json
python3 manage.py loaddata app/seeds/auth.json

echo "Handling assets/static files..."
python3 manage.py collectstatic --no-input --skip-checks

echo "Coping 'assets' folder to 'public_html'..."
mkdir ../public_html/assets && cp -rf static/* ../public_html/assets
cp -fr media ../public_html/

# Cpanel entrypoint.
echo "from app.wsgi import application" > passenger_wsgi.py

# Fixing permissions
echo "Fixing files & folders permissions..."
find . -type d -exec chmod 755 {} \; && find . -type f -exec chmod 644 {} \;

echo "Installation successfully completed."
# container restart is required!
